<?php
error_reporting(E_ALL ^ E_NOTICE);
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

if (!isset($datos[0])) {
    error_response("Parámetro requerido no proporcionado.");
}

$idProducto = $datos[0];

try {
    // Preparar y ejecutar el llamado a la función/procedimiento
    $sql = "SELECT * FROM UltimaVenta_Producto(:idproducto)";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':idproducto', $idProducto, PDO::PARAM_INT);
    $stmt->execute();

    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Verificar si hay datos
    if (!$rows) {
        error_log("⚠️ No se encontraron ventas con esos filtros.");
    }

    success_response("Consulta exitosa", $rows);

} catch (PDOException $e) {
    error_log("❌ Error en la consulta: " . $e->getMessage());
    error_response("Error al obtener la información de la base de datos.");
} finally {
    $conn = null; // ✅ Cerrar conexión PDO
}

// ✅ Funciones auxiliares
function success_response($mensaje, $data = []) {
    echo json_encode([
        "estado" => "00",
        "mensaje" => $mensaje,
        "data" => $data
    ], JSON_UNESCAPED_UNICODE);
    exit();
}

function error_response($mensaje) {
    http_response_code(500);
    echo json_encode([
        "estado" => "99",
        "mensaje" => $mensaje,
        "data" => []
    ], JSON_UNESCAPED_UNICODE);
    exit();
}
