<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Validar token antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

$rows = [];

try {
    // Preparar la llamada a la función almacenada (PostgreSQL usa SELECT para funciones que retornan resultados)
    $sql = "SELECT * FROM Verifica_CobrosxDoc(:param1, :param2, :param3)";
    $stmt = $conn->prepare($sql);

    // Asignar los parámetros
    $stmt->bindValue(':param1', $datos[0], PDO::PARAM_INT);
    $stmt->bindValue(':param2', $datos[1], PDO::PARAM_INT);
    $stmt->bindValue(':param3', $datos[2], PDO::PARAM_INT);

    // Ejecutar
    $stmt->execute();

    // Obtener resultados
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (!$rows) {
        $rows = [];
    }
} catch (PDOException $e) {
    error_response("Error al ejecutar la consulta: " . $e->getMessage());
}

// Cerrar conexión
$conn = null;

// Imprimir respuesta JSON
print_json($rows);

function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);

    switch (json_last_error()) {
        case JSON_ERROR_NONE:
            break;
        case JSON_ERROR_DEPTH:
            error_response('Maximum stack depth exceeded');
            break;
        case JSON_ERROR_STATE_MISMATCH:
            error_response('Underflow or the modes mismatch');
            break;
        case JSON_ERROR_CTRL_CHAR:
            error_response('Unexpected control character found');
            break;
        case JSON_ERROR_SYNTAX:
            error_response('Syntax error, malformed JSON');
            break;
        case JSON_ERROR_UTF8:
            error_response('Malformed UTF-8 characters, possibly incorrectly encoded');
            break;
        default:
            error_response('Unknown error');
            break;
    }
}

function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
?>