<?php
error_reporting(E_ALL ^ E_NOTICE);

// Permite la ejecución de los métodos
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

// Se incluye el archivo que contiene la conexión a la base de datos
include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

$bodyRequest = file_get_contents("php://input");
// Decodifica el cuerpo de la solicitud y lo guarda en un array de PHP
$datos = json_decode($bodyRequest, true);

$rows = array();
$sql = "SELECT documento_identidad FROM clientes WHERE empresa_id = ? AND documento_identidad = ? LIMIT 1";

try {
    $conn = conectarDB(); // Obtener conexión con PDO
    $stmt = $conn->prepare($sql);
    
    // Vincular parámetros
    $stmt->bindParam(1, $datos[0], PDO::PARAM_INT);
    $stmt->bindParam(2, $datos[1], PDO::PARAM_STR);
    
    // Ejecutar la sentencia
    $stmt->execute();
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Verificar si hay datos
    if (!$rows) {
        error_log("⚠️ No se encontraron clientes con esos filtros.");
    }
    
} catch (PDOException $e) {
    error_response("Error en la consulta: " . $e->getMessage());
} finally {
    $stmt = null; // Cerrar la sentencia
    $conn = null; // Cerrar la conexión
}

// Imprimir la respuesta en formato JSON
print_json($rows);

function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);

    switch (json_last_error()) {
        case JSON_ERROR_NONE:
            break;
        case JSON_ERROR_DEPTH:
            error_response('Maximum stack depth exceeded');
            break;
        case JSON_ERROR_STATE_MISMATCH:
            error_response('Underflow or the modes mismatch');
            break;
        case JSON_ERROR_CTRL_CHAR:
            error_response('Unexpected control character found');
            break;
        case JSON_ERROR_SYNTAX:
            error_response('Syntax error, malformed JSON');
            break;
        case JSON_ERROR_UTF8:
            error_response('Malformed UTF-8 characters, possibly incorrectly encoded');
            break;
        default:
            error_response('Unknown error');
            break;
    }
}

function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
?>