<?php
error_reporting(E_ALL);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Validar token antes de cualquier operación
$usuarioId = TokenValidator::validar($conn);

try {
    // Leer datos JSON del cuerpo
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!is_array($datos) || count($datos) < 3) {
        throw new Exception("Parámetros incompletos: se esperan [empresa_id, nserie, ndocumento].");
    }

    // Consulta segura (función en PostgreSQL que recibe 3 parámetros)
    $sql = "SELECT * FROM Buscar_DocVenta(:empresa_id, :nserie, :ndocumento)";
    $stmt = $conn->prepare($sql);

    // Enlazar parámetros
    $stmt->bindValue(':empresa_id', $datos[0], PDO::PARAM_INT);
    $stmt->bindValue(':nserie',     $datos[1], PDO::PARAM_STR);
    $stmt->bindValue(':ndocumento', $datos[2], PDO::PARAM_STR);

    // Ejecutar y obtener resultados
    $stmt->execute();
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode($rows, JSON_UNESCAPED_UNICODE);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Error en la consulta: ' . $e->getMessage()], JSON_UNESCAPED_UNICODE);
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['error' => $e->getMessage()], JSON_UNESCAPED_UNICODE);
} finally {
    $conn = null;
}
